<?php
/**
 * Sitemap stylesheet.
 *
 * @package    RankMath
 * @subpackage RankMath\Sitemap
 */

use RankMath\KB;
use RankMath\Sitemap\Router;
use RankMath\Sitemap\Sitemap;

defined( 'ABSPATH' ) || exit;

// Echo so opening tag doesn't get confused for PHP.
echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<xsl:stylesheet version="2.0"
	xmlns:html="http://www.w3.org/TR/REC-html40"
	xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
	xmlns:news="http://www.google.com/schemas/sitemap-news/0.9"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
<xsl:template match="/">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title><?php echo esc_html( $title ); ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<style type="text/css">
			body {
				font-size: 14px;
				font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;
				margin: 0;
				color: #545353;
			}
			a {
				color: #05809e;
				text-decoration: none;
			}
			h1 {
				font-size: 24px;
				font-family: Verdana,Geneva,sans-serif;
				font-weight: normal;
				margin: 0;
			}

			#description {
				background-color: #4275f4;
				padding: 20px 40px;
				color: #fff;
				padding: 30px 30px 20px;
			}
			#description h1,
			#description p,
			#description a {
				color: #fff;
				margin: 0;
				font-size: 1.1em;
			}
			#description h1 {
				font-size: 2em;
				margin-bottom: 1em;
			}
			#description p {
				margin-top: 5px;
			}

			#content {
				padding: 20px 30px;
				background: #fff;
				max-width: 75%;
				margin: 0 auto;
			}

			table {
				border: none;
				border-collapse: collapse;
				font-size: .9em;
				width: 100%;
			}
			th {
				background-color: #4275f4;
				color: #fff;
				text-align: left;
				padding: 15px;
				font-size: 14px;
				cursor: pointer;
			}
			td {
				padding: 10px;
				border-bottom: 1px solid #ddd;
			}
			tbody tr:nth-child(even) {
				background-color: #f7f7f7;
			}
			table td a {
				display: block;
			}
			table td a img {
				max-height: 30px;
				margin: 6px 3px;
			}
		</style>
	</head>
	<body>
	<div id="description">
		<h1><?php esc_html_e( 'XML Sitemap', 'rank-math-pro' ); ?></h1>
		<?php if ( false === $this->do_filter( 'sitemap/remove_credit', false ) ) : ?>
			<p>
				<?php
				printf(
					wp_kses_post(
						/* translators: link to rankmath.com */
						__( 'This XML Sitemap is generated by <a href="%s" target="_blank">Rank Math WordPress SEO Plugin</a>. It is what search engines like Google use to crawl and re-crawl posts/pages/products/images/archives on your website.', 'rank-math-pro' )
					),
					esc_url( KB::get( 'seo-suite' ) )
				);
				?>
			</p>
		<?php endif; ?>

		<p>
			<?php
			printf(
				wp_kses_post(
					/* translators: link to rankmath.com */
					__( 'Learn more about <a href="%s" target="_blank">XML Sitemaps</a>.', 'rank-math-pro' )
				),
				'http://sitemaps.org'
			);
			?>
		</p>
	</div>
	<div id="content">
		<p>
			<?php
			printf(
				/* translators: xsl value count */
				__( 'This XML Sitemap contains <strong>%s</strong> URLs.', 'rank-math-pro' ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- escaping it would break the output.
				'<xsl:value-of select="count(sitemap:urlset/sitemap:url)"/>'
			);
			?>
		</p>
		<p class="expl">
			<?php
			echo wp_kses(
				sprintf(
					/* translators: xsl value count */
					__( '<a href="%s">&#8592; Sitemap Index</a>', 'rank-math-pro' ),
					esc_url( Router::get_base_url( Sitemap::get_sitemap_index_slug() . '.xml' ) )
				),
				[ 'a' => [ 'href' => [] ] ]
			);
			?>
		</p>
		<table id="sitemap" cellpadding="3">
			<thead>
			<tr>
				<th width="40%">Title</th>
				<th width="15%"><?php esc_html_e( 'Publication Date', 'rank-math-pro' ); ?></th>
			</tr>
			</thead>
			<tbody>
			<xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
			<xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
			<xsl:for-each select="sitemap:urlset/sitemap:url">
				<tr>
					<td>
						<xsl:variable name="itemURL">
							<xsl:value-of select="sitemap:loc"/>
						</xsl:variable>
						<a href="{$itemURL}">
							<xsl:value-of select="news:news/news:title"/>
						</a>
					</td>
					<td>
						<xsl:value-of select="concat(substring(news:news/news:publication_date,0,11),concat(' ', substring(news:news/news:publication_date,12,8)),concat(' ', substring(news:news/news:publication_date,20,6)))"/>
					</td>
				</tr>
			</xsl:for-each>
			</tbody>
		</table>
	</div>
	</body>
	</html>
</xsl:template>
</xsl:stylesheet>
